% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{generateBoxplotsMultipleCats}
\alias{generateBoxplotsMultipleCats}
\title{Wrapper function to generate all boxplots for the specified analytes split by defined categories}
\usage{
generateBoxplotsMultipleCats(
  analytes,
  errorListAll,
  colList,
  nameList,
  category = c("fractionPathol", "fractionPathol_cum", "N", "N_cum", "OvFreq",
    "OvFreq_cum"),
  catList = NULL,
  catLabels = NULL,
  errorParam = "zzDevAbs_Ov",
  outline = TRUE,
  withMean = TRUE,
  withDirect = TRUE,
  withCats = TRUE,
  titlePart = NULL,
  outputDir = NULL,
  filenamePart = NULL,
  ylim1Vec = NULL,
  ylim2Vec = NULL,
  yticks1Vec = NULL,
  yticks2Vec = NULL,
  ...
)
}
\arguments{
\item{analytes}{(character) vector specifying for which analytes the plots should be generated}

\item{errorListAll}{(named list) containing the overall benchmark results per algorithm (names of list elements should be the names of the algorithms)}

\item{colList}{(character) vector specifying the colors used for the different algorithms (should correspond to columns of benchmark results)}

\item{nameList}{(character) vector specifying the names used in the legend (should correspond to columns of benchmark results), if NULL, colnames will be used}

\item{category}{(character) defining the category used for creating the subsets. All defined sub-features are used for the categorization. 
Choose from "fractionPathol" (default), "N", or "OvFreq", individual or cumulative ("_cum"); if category is set this
will be used to define catList and catLabels}

\item{catList}{(character) vector specifying the categories for which the boxes should be drawn}

\item{catLabels}{(character) vector specifying the labels to the associated categories used for the x-axis}

\item{errorParam}{(charcter) specifying for which error measure the plot should be generated}

\item{outline}{(logical) indicating whether outliers should be drawn (TRUE, default), or not (FALSE)}

\item{withMean}{(logical) indicating whether the mean should be plotted as well (default: TRUE)}

\item{withDirect}{(logical) indicating whether the box of the direct method should be elongated to facilitate comparison (default:TRUE)}

\item{withCats}{(logical) set to TRUE if categories (e.g. pathological fraction) should be plotted (default: FALSE)}

\item{titlePart}{(character) specifying the latter part of the title}

\item{outputDir}{(character) specifying an output directory}

\item{filenamePart}{(character) specifying a filename for the plot}

\item{ylim1Vec}{(numeric) vector specifying the limits in y-direction for the first granular scale}

\item{ylim2Vec}{(numeric) vector specifying the limits in y-direction for the second less detailed scale}

\item{yticks1Vec}{(numeric) vector specifying the ticks in y-direction for the first granular scale}

\item{yticks2Vec}{(numeric) vector specifying the ticks in y-direction for the second less detailed scale}

\item{...}{additional arguments passed forward to other functions}
}
\value{
No return value. Instead, a plot is generated.
}
\description{
Wrapper function to generate all boxplots for the specified analytes split by defined categories
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
