% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.chemSigSelect.R
\name{plot.chemSigSelect}
\alias{plot.chemSigSelect}
\title{Plot method for 'chemSigSelect'}
\usage{
\method{plot}{chemSigSelect}(
  x,
  paramList = NULL,
  type = c("boxplot", "ecdf", "density"),
  logAxes = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{chemSigSelect} class object}

\item{paramList}{character vector of column names of chemical concentration variables in \code{data}; values will be inherited from \code{x} if not specified}

\item{type}{character vector indicating the type of plot to generate (see Details; default = \code{c("boxplot", "ecdf", "density")})}

\item{logAxes}{logical value; whether axes should be projected in log-space (default = \code{TRUE})}

\item{...}{additional arguments passed to \code{plot}. The user currently has limited capacity to change graphical parameters.}
}
\value{
base graphics
}
\description{
The plot method for 'chemSigSelect' objects
}
\details{
\code{plot.chemSigSelect} is a class-specific plotting function that generates boxplots, empirical cumulative density functions, or
kernel density plots comparing the \code{Hit == TRUE} and \code{Hit == FALSE} subsets for all chemicals in \code{paramList}.
By default, all plot types are generated, but \code{type} can be changed to generate specific plot types. The available types are
specified by \code{"type = boxplot"}, \code{"type = ecdf"}, and \code{"type = density"}, though character inputs are flexible;
for example, other reasonable versions of these types include \code{"Boxplot"} and \code{"ECDF"}.
Note that because \code{boxplot}, \code{plot.ecdf}, and \code{plot.density} functions use plotting arguments in different ways, supplying
user-defined plotting arguments may cause unintended changes (or possibly errors or warnings) when plotting multiple types. For that reason, we recommend that the user
select a specific plot type (using the \code{type} argument) before adjusting plot arguments (via \code{...}) that apply to that type.
Moreover, many of the plotting arguments are specified by \code{plot.chemSigSelect} and, therefore, cannot be
adjusted by the user. These include but are not limited to parameters like \code{col} and \code{lwd}.
}
\examples{
x <- chemSigSelect(data = h.tristate, paramList = c("Cd", "Cu", "Fe", "Mn", "Ni", "Pb", "Zn"))
plot(x, type = "boxplot")
}
\seealso{
chemSigSelect, boxplot, plot.ecdf, plot.density
}
