% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{cmip5data}
\alias{cmip5data}
\title{The 'cmip5data' class}
\usage{
cmip5data(x = list(), lonlat = TRUE, lonsize = 10, latsize = 10,
  Z = FALSE, Zsize = 5, time = TRUE, monthly = TRUE,
  randomize = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{A list or numeric. If x is a list then the fields are expected to match those of the returned cmip5data object. If x is a numeric sample data is created where the numeric indicates the years of sample data to return.}

\item{lonlat}{Boolean indicating whether to create lon and lat dimensions}

\item{lonsize}{Integer size of longitude dimension}

\item{latsize}{Integer size of latitude dimension}

\item{Z}{logical. Create Z dimension?}

\item{Zsize}{integer. Size of Z dimension}

\item{time}{logical. Create time dimension?}

\item{monthly}{logical. Monthly (if not, annual) data?}

\item{randomize}{logical. Random sample data?}

\item{verbose}{logical. Print info as we go?}
}
\value{
A cmip5data object, which is a list with the following fields:
 \item{files}{Array of strings containg the file(s) included in this dataset}
 \item{variable}{String containg the variable name described by this dataset}
 \item{model}{String containing the model name of this dataset}
 \item{experiment}{String containing the experiment name of this dataset}
 \item{ensembles}{Array of strings containg the ensemble(s) included in this dataset}
 \item{domain}{String containing the domain name of this dataset}
 \item{val}{Multidimensional array [x, y, z, t] holding the data}
 \item{valUnit}{String containing the value units}
 \item{lon}{Numeric vector containing longitude values; may be \code{NULL}}
 \item{lat}{Numeric vector containing latitude values; may be \code{NULL}}
 \item{Z}{Numeric vector Z values; may be \code{NULL}}
 \item{time}{Numeric vector containing time values; may be \code{NULL}}
 \item{dimNames}{Array of strings containing the original (netcdf) dimension names}
 \item{calendarStr}{String defining the calendar type; may be \code{NULL}}
 \item{debug}{List with additional data (subject to change)}
 \item{provenance}{Data frame with the object's provenance. See \code{\link{addProvenance}}}
 \item{numPerYear}{Numeric vector; only present after \code{\link{makeAnnualStat}}}
 \item{numYears}{Numeric vector; only present after \code{\link{makeMonthlyStat}}}
 \item{numCells}{Numeric vector; only present after \code{\link{makeGlobalStat}}}
 \item{filtered}{Logical; only present after \code{\link{filterDimensions}}}
}
\description{
This constructor has two functions. First, given a list, it makes the list
a cmip5data-class object (no check is made that the list has appropriate
fields though). Second, if given a numeric value(s), it returns sample/
example data in the newly constructed object. This is used extensively by
the testing code.
}
\examples{
cmip5data(1970)  # produces monthly sample data for year 1970
cmip5data(1970:2014)
cmip5data(1970:2014, monthly=FALSE)  # annual data
cmip5data(1970:2014, randomize=TRUE) # randomized data
cmip5data(1970:2014, Z=TRUE)  # four-dimensional data
cmip5data(0, time=FALSE)  # sample 'fx' data, two-dimensional
cmip5data(list())  # makes this (here empty) list class into 'cmip5data'
}

