% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldAllBr.R
\name{foldAllBr}
\alias{foldAllBr}
\title{Easily Fold Code Parts}
\usage{
foldAllBr(time = FALSE, debug_getTbl = FALSE)
}
\arguments{
\item{time}{Logical. If `TRUE`, the function will return \code{ggplot} object
visualizing execution times for each step.}

\item{debug_getTbl}{Logical. If `TRUE`, returns the `docContent` table with
tags for debugging purposes.}
}
\value{
A list containing:
\itemize{
  \item \code{debug_info}: A data frame with debugging information if \code{debug_getTbl = TRUE}.
  \item \code{timer_plot}: A \code{ggplot} object visualizing execution times if \code{time = TRUE}.
}
If both parameters are \code{FALSE}, the function returns a list with \code{NULL} values.
}
\description{
This function works with code split into parts identified by brackets.
The format is as follows:
\preformatted{
\{
  ...
  code from part 1
  ...
\} # part 1
\{
  ...
\} # part 2
}

It automatically identifies parts to fold/unfold easily.

Shortcuts required:
\itemize{
  \item "fold all brackets": shift + alt + S (Windows) / ctrl + shift + up (Mac)
  \item "expand fold": shift + alt + D (Windows) / ctrl + shift + down (Mac)
}
}
