% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.MQ.R
\name{sim.MQ}
\alias{sim.MQ}
\title{Simulate Mis-specifications in Q-matrix}
\usage{
sim.MQ(Q, rate, verbose = TRUE)
}
\arguments{
\item{Q}{The Q-matrix (\code{\link[Qval]{sim.Q}}) that need to simulate mis-specifications.}

\item{rate}{The ratio of mis-specifications in the Q-matrix.}

\item{verbose}{Logical indicating to print information or not. Default is \code{TRUE}}
}
\value{
An object of class \code{matrix}.
}
\description{
simulate certen \code{rate} mis-specifications in the Q-matrix.
}
\examples{
library(Qval)

set.seed(123)

Q <- sim.Q(5, 10)
print(Q)

MQ <- sim.MQ(Q, 0.1)
print(MQ)

}
\author{
Haijiang Qin <Haijiang133@outlook.com>
}
