% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tenf.R
\name{tenf.crr}
\alias{tenf.crr}
\title{Obtain K-Fold Cross-Validated Predictions}
\usage{
tenf.crr(fit, time = NULL, lps = FALSE, fold = 10, trace = TRUE)
}
\arguments{
\item{fit}{A model fit by \code{\link[QHScrnomo]{crr.fit}}}

\item{time}{A single time point to calculate the failure probability}

\item{lps}{Should the linear predictor be returned instead of the failure probability? Defaults to \code{FALSE}.}

\item{fold}{The number of folds. Defaults to \code{10}.}

\item{trace}{Should the progress of cross-validation be printed to the console? Defaults to \code{TRUE}.}
}
\value{
A vector of failure probabilities at the specified time point (or linear predictors if \code{lps=TRUE}) with length equal to the number of rows in the original data set.
}
\description{
Computes "out-of-sample" predictions by K-fold cross-validation for each observation in the modeling data set from a \code{\link[QHScrnomo]{crr.fit}} object.
}
\examples{
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y = TRUE, surv = TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f, cencode = 0, failcode = 1)
tenf.crr(prostate.crr, time = 120, fold = 2)

}
\seealso{
\code{\link[QHScrnomo]{crr.fit}} \code{\link[cmprsk]{crr}}
}
\author{
Changhong Yu, Michael Kattan, Ph.D \cr Department of Quantitative
Health Sciences\cr Cleveland Clinic\cr
}
\keyword{models}
\keyword{survival}
