% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cluster.R
\name{makeCluster}
\alias{makeCluster}
\title{Create a cluster of nodes for parallel computation}
\usage{
makeCluster(
  numberOfThreads,
  singleThreadToMain = TRUE,
  setAndromedaTempFolder = TRUE,
  setAndromedaMemoryLimit = TRUE
)
}
\arguments{
\item{numberOfThreads}{Number of parallel threads.}

\item{singleThreadToMain}{If \code{numberOfThreads} is 1, should we fall back to running the
process in the main thread?}

\item{setAndromedaTempFolder}{When TRUE, the andromedaTempFolder option will be copied to each
thread.}

\item{setAndromedaMemoryLimit}{When TRUE, the andromedaMemoryLimit option will be set in each 
thread to be either the global andromedaMemoryLimit / numberOfThreads
or 75 percent of the system memory / number of threads.}
}
\value{
An object representing the cluster.
}
\description{
Create a cluster of nodes for parallel computation
}
\examples{
fun <- function(x) {
  return (x^2)
}

cluster <- makeCluster(numberOfThreads = 3)
clusterApply(cluster, 1:10, fun)
stopCluster(cluster)
}
