% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{plot.mpPLMIX}
\alias{plot.mpPLMIX}
\title{Plot the MAP estimates for a Bayesian mixture of Plackett-Luce models}
\usage{
\method{plot}{mpPLMIX}(x, max_scale_radar = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{mpPLMIX} returned by the \code{mpPLMIX} function.}

\item{max_scale_radar}{Numeric scalar indicating the maximum value on each axis of the radar plot for the support parameter point estimates. Default is \code{NULL} meaning that the maximum of the estimated support parameters is used.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\description{
\code{plot} method for class \code{mpPLMIX}.
}
\details{
By recalling the \code{chartJSRadar} function from the \code{radarchart} package and the routines of the \code{ggplot2} package, \code{plot.mpPLMIX} produces a radar plot of the support parameters and, when \eqn{G>1}, a donut plot of the mixture weights and a heatmap of the component membership probabilities based on the MAP estimates.  The radar chart is returned in the Viewer Pane.
}
\examples{

# Not run:
data(d_carconf)
MAP <- mapPLMIX(pi_inv=d_carconf, K=ncol(d_carconf), G=3)
plot(MAP)

# Not run:
MAP_multi <- mapPLMIX_multistart(pi_inv=d_carconf, K=ncol(d_carconf), G=3, n_start=5)
plot(MAP_multi)
}
\references{
Ashton, D. and Porter, S. (2016). radarchart: Radar Chart from 'Chart.js'. R package version 0.3.1. \url{https://CRAN.R-project.org/package=radarchart}

Wickham, H. (2009). ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York.
}
\seealso{
\code{\link[radarchart]{chartJSRadar}} and \code{\link[ggplot2]{ggplot}}
}
\author{
Cristina Mollica and Luca Tardella
}
