% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_df_to_srl.R
\name{convert_df_to_srl}
\alias{convert_df_to_srl}
\title{Convert dataframe to SpatRaster list}
\usage{
convert_df_to_srl(x, date_col = "date")
}
\arguments{
\item{x}{dataframe (tmean, tmax, tmin, date)}

\item{date_col}{\itemize{
\item character - name for date column which will be used to
create time attribute of SpatRaster.
}}
}
\value{
SpatRaster list (tmean, tmax, tmin) - numeric - with time attribute
}
\description{
Internal function to create a SpatRaster list out of a dataframe.

By default the dataframe should have a date column called "date".
The function is transferring each column into a list object and this object
to a 1 col, 1 row nrow nlyr SpatRaster.
}
\seealso{
Other SpatRaster transformation: 
\code{\link{convert_doy_to_logical}()},
\code{\link{convert_hour_to_meanminmax}()},
\code{\link{convert_logical_to_doy}()},
\code{\link{convert_logical_to_time}()},
\code{\link{convert_sr_to_cvec}()}
}
\concept{SpatRaster transformation}
\keyword{internal}
