% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PACLasso.R
\name{lars.c}
\alias{lars.c}
\title{Constrained LARS Coefficient Function (Equality Constraints)}
\usage{
lars.c(x, y, C.full, b, l.min = -2, l.max = 6, step = 0.2,
  beta0 = NULL, verbose = F, max.it = 12, intercept = T,
  normalize = T, forwards = T)
}
\arguments{
\item{x}{independent variable matrix of data to be used in calculating PaC coefficient paths}

\item{y}{response vector of data to be used in calculating PaC coefficient paths}

\item{C.full}{complete constraint matrix C (with constraints of the form \code{C.full}*\code{beta}=\code{b})}

\item{b}{constraint vector b}

\item{l.min}{lowest value of lambda to consider (used as 10^\code{l.min}). Default is -2}

\item{l.max}{largest value of lambda to consider (used as 10^\code{l.max}). Default is 6}

\item{step}{step size increase in lambda attempted at each iteration (by a factor of 10^\code{step}). Default is 0.2}

\item{beta0}{initial guess for beta coefficient vector. Default is NULL (indicating
initial vector should be calculated by algorithm)}

\item{verbose}{should function print output at each iteration (TRUE) or not (FALSE). Default is FALSE}

\item{max.it}{maximum number of times step size is halved before the algorithm terminates and gives a warning. Default is 12}

\item{intercept}{should intercept be included in modeling (TRUE) or not (FALSE). Default is TRUE.}

\item{normalize}{should \code{x} data be normalized. Default is TRUE}

\item{forwards}{if \code{forwards} = F, then the algorithm starts at 10^\code{l.max} and
moves backwards (without the forward step). If \code{forwards} = T,
algorithm starts at 10^\code{l.min} and works forward. Default is FALSE}
}
\value{
\code{coefs} A \code{p} by length(\code{lambda}) matrix with each column corresponding to the beta estimate for that lambda

\code{lambda} the grid of lambdas used to calculate the coefficients on the coefficient path

\code{intercept} vector with each element corresponding to intercept for corresponding lambda

\code{error} did the algorithm terminate due to too many iterations (TRUE or FALSE)

\code{b2index} the index of the \code{beta2} values identified by the algorithm at each lambda
}
\description{
This function computes the PaC constrained LASSO
  coefficient paths following the methodology laid out in the PaC
  paper. This function could be called directly as a standalone
  function, but the authors recommend using \code{lasso.c} for any
  implementation. This is because \code{lasso.c} has additional checks for
  errors across the coefficient paths and allows for users to go
  forwards and backwards through the paths if the paths are unable
  to compute in a particular direction for a particular run.
}
\examples{
random_data = generate.data(n = 500, p = 20, m = 10)
lars_fit = lars.c(random_data$x, random_data$y, random_data$C.full, random_data$b)
lars_fit$lambda
lars_fit$error
### The coefficients for the first lambda value
lars_fit$coefs[1,]
### Example of code where path is unable
### to be finished (only one iteration)
lars_err = lars.c(random_data$x, random_data$y, random_data$C.full,
random_data$b, max.it = 1)
lars_err$error
lars_err$lambda
}
\references{
Gareth M. James, Courtney Paulson, and Paat Rusmevichientong (JASA, 2019) "Penalized and Constrained Optimization."
(Full text available at http://www-bcf.usc.edu/~gareth/research/PAC.pdf)
}
