% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{getPlottingData}
\alias{getPlottingData}
\title{Get plotting data}
\usage{
getPlottingData(study, modelID, featureID, testID = NULL, libraries = NULL)
}
\arguments{
\item{study}{An OmicNavigator study. Either an object of class \code{onStudy},
or the name of an installed study package.}

\item{modelID}{Filter by modelID}

\item{featureID}{Filter by featureID}

\item{testID}{Filter by testID}

\item{libraries}{The directories to search for installed study packages. If
left as \code{NULL} (the default), then
\code{\link[utils]{installed.packages}} will use the result of
\code{\link{.libPaths}}.}
}
\value{
Returns a list of 4 data frames:

\item{\code{assays}}{A data frame that contains the assay measurements,
filtered to only include the row(s) corresponding to the input featureID(s)
(see \code{\link{getAssays}}). If multiple featureIDs are requested, the rows
are reordered to match the order of this input. The column order is
unchanged.}

\item{\code{samples}}{A data frame that contains the sample metadata for the
given modelID (see \code{\link{getSamples}}). The rows are reordered to match
the columns of the assays data frame.}

\item{\code{features}}{A data frame that contains the feature metadata,
filtered to only include the row(s) corresponding to the input featureID(s)
(see \code{\link{getFeatures}}). If multiple featureIDs are requested, the
rows are reordered to match the order of this input (and thus match the order
of the assays data frame).}

\item{\code{results}}{A data frame that contains the test results,
filtered to only include the row(s) corresponding to the input featureID(s).
If multiple featureIDs are requested, the rows are reordered to match the
order of this input. The column order is unchanged. If multiple testIDs are
provided, they are stored in a list object.}

The data frame \code{results} is only returned if you pass a testID. By
default the app will always pass the currently selected testID. To make
\code{results} a list of data frames (one for each testID for the currently
selected modelID), set the plotType to be "multiTest" when adding the plot
with \code{\link{addPlots}}. For "multiModel" plots, testID and modelID
should be vectors of same length, where the index position indicate which
test in testID relate to which model in modelID.
}
\description{
This function creates the input data that \code{\link{plotStudy}} passes to
custom plotting functions added with \code{\link{addPlots}}. You can use it
directly when you are interactively creating your custom plotting functions.
Note that for multiModel plots testID is required to be a named vector, with
each testID named after the related modelID.
}
\seealso{
\code{\link{addPlots}}, \code{\link{plotStudy}}
}
