% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPCR.R
\name{SPCR}
\alias{SPCR}
\title{The stochastic principal component method can handle online data sets.}
\usage{
SPCR(data, eta, m)
}
\arguments{
\item{data}{A data frame containing the response variable and predictors.}

\item{eta}{proportion (between 0 and 1) determining the initial sample size for PCA.}

\item{m}{The number of principal components to retain.}
}
\value{
A list containing the following elements:
\item{Bhat}{The estimated regression coefficients, including the intercept.}
\item{RMSE}{The Root Mean Square Error of the regression model.}
\item{summary}{The summary of the linear regression model.}
\item{yhat}{The predicted values of the response variable.}
}
\description{
The stochastic principal component method can handle online data sets.
}
\examples{
# Example data
library(MASS);library(stats)
set.seed(1234)
n <- 2000
p <- 10
mu0 <- as.matrix(runif(p, 0))
sigma0 <- as.matrix(runif(p, 0, 10))
ro <- as.matrix(c(runif(round(p / 2), -1, -0.8), runif(p - round(p / 2), 0.8, 1)))
R0 <- ro \%*\% t(ro)
diag(R0) <- 1
Sigma0 <- sigma0 \%*\% t(sigma0) * R0
x <- mvrnorm(n, mu0, Sigma0)
colnames(x) <- paste("x", 1:p, sep = "")
e <- rnorm(n, 0, 1)
B <- sample(1:3, (p + 1), replace = TRUE)
en <- matrix(rep(1, n * 1), ncol = 1)
y <- cbind(en, x) \%*\% B + e
colnames(y) <- paste("y")
data <- data.frame(cbind(y, x))
result <- SPCR(data,  eta = 0.0035, m = 3)
}
