% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateOscillators.R
\name{updateOscillators}
\alias{updateOscillators}
\title{Update oscillator parameter of an existing ODE network.}
\usage{
updateOscillators(
  odenet,
  ParamVec = NULL,
  masses = NULL,
  dampers = NULL,
  springs = NULL,
  distances = NULL,
  state1 = NULL,
  state2 = NULL
)
}
\arguments{
\item{odenet}{[\code{ODEnetwork}]\cr
List of class \code{\link{ODEnetwork}}.}

\item{ParamVec}{[\code{vector}] of length n\cr
Named vector to overwrite corresponding parameters.
Masses start with "m." followed by a number (e.g.: "m.12").
Dampers start with "d." followed by one or two numbers separated by a dot (e.g.: "d.2", "d.5.6").
Springs start with "k.", like dampers (e.g.: "k.4", "k.3.9")
Distances start with "r.", like dampers (e.g.: "r.7", "r.1.9")
The triangle elements of the dampers, springs, and distances are characterised by increasing numbers.
A name "d.3.5" is correct, in contrast to "d.5.3" which is ignored.
This is done to speed up, because the matrices are symmetric.
State1 and state2 start with "st1." or "st2." respectively, followed by a number (e.g.: "st1.15", "st2.8").
If the vector is set, the following parameters are ignored.}

\item{masses}{[\code{vector}] of length n\cr
The masses of the mechanical oscillators.}

\item{dampers}{[\code{matrix}] quadratic of size n\cr
The dampers of the mechanical oscillators on the main diagonal.
Connecting dampers between oscillators on the upper triangle.
(Will be copied automatically to create a symmetric matrix.)}

\item{springs}{[\code{matrix}] quadratic of size n\cr
The springs are defined in the network like matrix of dampers.}

\item{distances}{[\code{matrix}] quadratic of size n\cr
Describe spring distance between two masses i < j.
Negative value will be copied automatically to lower triangle.}

\item{state1}{[\code{vector}] of length n\cr
Starting values of state 1 (position or angle).}

\item{state2}{[\code{vector}] of length n\cr
Starting values of state 2 (velocity or magnitude).}
}
\value{
an extended list of class [\code{\link{ODEnetwork}}].
}
\description{
Updates the parameters of an existing ODE network.
Possible parameters are the oscillator configuration and the starting values.
The function overwrites the parameters in the vector and matrices.
It will not change the size of the network.
It is possible to set a new vector and new matrices, or single parameters in a names vector.
}
\examples{
masses <- c(1:5)
dampers <- diag(11:15)
springs <- diag(21:25)
odenet <- ODEnetwork(masses, dampers, springs)
odenet <- updateOscillators(odenet, masses = c(3:7))
odenet <- updateOscillators(odenet, c(k.1.2 = 201, k.3.5 = 202, r.1 = 2))
# Warning: Following value is ignored, because it is on the lower triangle
odenet <- updateOscillators(odenet, c(d.2.1 = 101))
}
