% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clsODEnetwork.R
\name{ODEnetwork}
\alias{ODEnetwork}
\title{Constructor of the class ODEnetwork}
\usage{
ODEnetwork(masses, dampers, springs, cartesian = TRUE, distances = NA)
}
\arguments{
\item{masses}{[\code{vector}] of length n\cr
The masses of the mechanical oscillators.}

\item{dampers}{[\code{matrix}] quadratic of size n\cr
The dampers of the mechanical oscillators on the main diagonal.
Connecting dampers between oscillators on the upper triangle.
(Will be copied automatically to create a symmetric matrix.)}

\item{springs}{[\code{matrix}] quadratic of size n\cr
The springs are defined in the network like matrix of dampers.}

\item{cartesian}{[\code{boolean(1)}]\cr
If \code{TRUE}, \code{state1} and \code{state2} are position and velocity,
otherwise angle and magnitude.
Default is \code{TRUE}.}

\item{distances}{[\code{matrix}] quadratic of size n\cr
Describes the length of each spring.
Elements on the main diagonal describe spring length connecting the masses to the ground.
All upper triangle elements describe spring distance between two masses i < j.
Default is \code{NA}, which is equivalent to a zero matrix.
(Value will be copied automatically to lower triangle creating a symmetric matrix.)}
}
\value{
a list of class [\code{\link{ODEnetwork}}].
}
\description{
Creates a list of class \code{ODEnetwork}.
The coordinate type can be set to cartesian (position and
velocity) or to polar coordinates (angle and magnitude).
}
\examples{
mM <- c(40, 10, 10)
mD <- diag(c(1, 5, 0))
mD[1, 2] <- 1
mD[2, 3] <- 1
mK <- diag(c(50, 50, 0))
mK[1, 2] <- 10
mK[2, 3] <- 10
odenet <- ODEnetwork(mM, mD, mK)
}
