% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneAgeTest.R
\docType{methods}
\name{popline-methods}
\alias{popline-methods}
\alias{popline}
\alias{popline,oneAgeTest-method}
\alias{popline.oneAgeTest}
\alias{popline,ageTests-method}
\alias{popline.ageTests}
\title{Method \code{"popline"} for Classes \code{"\linkS4class{oneAgeTest}"} and \code{"\linkS4class{ageTests}"}}
\usage{
\S4method{popline}{oneAgeTest}(x, main2 = "")
}
\arguments{
\item{x}{an object of class "oneAgeTest" or "ageTests" (see section Methods)}

\item{main2}{a character string, title of the plot}
}
\description{
Display observations as well as their reference's population as calculated 
by the function \code{\link{tests}()} given their value of Pb (ppm) 
and Th*(ppm), where Th* is a function of Th and U variables.
}
\details{
Th* is computed thanks to the following formula: 
\eqn{Th + 232*U * [238(exp(4.9475*10^{-5}*Age) - 1)]^{-1} * [[exp(9.8485*10^{-4}*Age + 138*exp(1.55125*10^{-4}*Age))][139] - 1]}

Slopes, depending directly of the ages computed with the function \code{\link{tests}()}, 
are obtained through the following equation: \eqn{[exp(4.9475*10^{-5}*Age) - 1] * 207.3/232}.
}
\section{Usage}{
 popline(x, main2)
}

\section{Methods}{

\itemize{
   \item \code{signature(object = "oneAgeTest")}: an object of type
         \code{\linkS4class{oneAgeTest}} as produced by the function
         \code{\link{tests}()}.
   \item \code{main2}: a character string to entitle the plot
}

\itemize{
   \item \code{signature(object = "ageTests")}: an object of type
         \code{\linkS4class{ageTests}} as produced by the function
         \code{\link{tests}()}.
   \item \code{main2}: a character string to entitle the plot
}
}

\examples{
data(srilanka)
calculated.ages <- calculateAges(srilanka, nloops = 10)
res.tests <- tests(calculated.ages, 1, 3)
popline(res.tests, main2 = "Populations")

}
\references{
Montel J.M., Foret S., Veschambre M., Nicollet C., Provost A. (1996) Electron
microprobe dating of monazite. \emph{Chemical Geology}, \bold{131}, 37--53.
}
\seealso{
\code{\link{tests}()}, \code{\linkS4class{oneAgeTest}}, \code{\linkS4class{ageTests}}
}
\author{
Aurélie Mercadié, \email{aurelie.mercadie@inrae.fr}

Jean-Marc Montel, \email{jean-marc.montel@ensg.inpl-nancy.fr}

Nathalie Vialaneix, \email{nathalie.vialaneix@inrae.fr}
}
\keyword{methods}
