% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{dy}
\alias{dy}
\alias{dy,agentMatrix,numeric-method}
\alias{dy,agentMatrix,missing-method}
\title{y-increment}
\usage{
dy(turtles, dist = 1)

\S4method{dy}{agentMatrix,numeric}(turtles, dist = 1)

\S4method{dy}{agentMatrix,missing}(turtles)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{dist}{Numeric. Vector of distances the \code{turtles} would have to
move forward to
compute the increment values. Must be of length 1 or of length
\code{turtles}. The default value is \code{dist = 1}.}
}
\value{
Numeric. Vector of length \code{turtles}.
}
\description{
Report the amount by which the \code{turtles}' coordinates \code{ycor} would change
if the \code{turtles} were
to move forward the given distances with their current \code{headings}.
}
\details{
Report the cosine of the \code{turtles}' \code{heading} multiplied by the \code{dist}
         values. Heading 0 is north and angles are calculated in degrees in a
         clockwise manner.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
t1 <- createOTurtles(world = w1, n = 10)
dy(turtles = t1)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#dxy}
}
\author{
Sarah Bauduin
}
