% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{rorschach}
\alias{rorschach}
\title{Rorschach inkblots}
\format{
A data frame with 600 rows and 5 columns:
\itemize{
\item The Panel effect (3 panels)
\item The Inkblot effect (10 inkblots)
\item The Panelist effect (20 panelists par panel)
\item The interaction Panel and Panelist
\item The perception of the inkblot
}
}
\source{
Applied mathematics department, Institut Agro Rennes-Angers
}
\usage{
rorschach
}
\description{
This dataset was initially collected to understand the perception of the Rorschach test.
}
\examples{
\dontrun{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(NaileR)
data(rorschach)

### Example 1: perception of the inkblots for one panel ###
intro_rorschach <- "For this study,
we asked 20 people to briefly describe
the 10 inkblots of the Rorschach test."
intro_rorschach <- gsub('\n', ' ', intro_rorschach) |>
stringr::str_squish()

request_rorschach <- "Based on the comments of the 20 people,
please give me a description of each inkblot
in terms of how it was perceived. Tell me if it was
a rather positive or negative perception."
request_rorschach <- gsub('\n', ' ', request_rorschach) |>
stringr::str_squish()

rorschach_A <- droplevels(rorschach[rorschach$Panel=="A",])

res_nail_textual_rorschach <- nail_textual(rorschach_A, num.var = 2,
                                           num.text = 5,
                                           introduction = intro_rorschach,
                                           request = request_rorschach,
                                           model = 'llama3',
                                           isolate.groups = FALSE,
                                           generate = FALSE)
res_nail_textual_rorschach |> cat()

ppt <- gsub("## Group", "## Inkblot", res_nail_textual_rorschach)
ppt |> cat()

res_inkblot <- ollamar::generate(model = 'llama3', prompt = ppt,
                                 output = "text")
res_inkblot |> cat()
}
}
\keyword{datasets}
