#' Cornejo2025 longitudinal dataset measured in transgender persons
#'
#' The Cornejo2025 longitudinal dataset as three-dimensional arrays,
#' with subjects in mode 1, features in mode 2 and time in mode 3.
#'
#' @format ## 'Cornejo2025'
#' A list object with three elements:
#' \describe{
#'     \item{Tongue_microbiome}{List object of the tongue longitudinal microbiota data.}
#'     \item{Salivary_microbiome}{List object of the saliva longitudinal microbiota data.}
#'     \item{Salivary_cytokines}{List object of the longitudinal salivary cytokine data.}
#'     \item{Salivary_biochemistry}{List object of the longitudinal salivary biochemistry data.}
#'     \item{Circulatory_hormones}{List object of the longitudinal circulatory hormone data.}
#'     \item{Clinical_measurements}{List object of the longitudinal clinical outcome data.}
#'     \item{Subject_metadata}{Matrix with subject metadata.}
#' }
#' @source TBD
"Cornejo2025"
