% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{get_levels}
\alias{get_levels}
\alias{get_levels_abcd}
\alias{get_levels_hbcd}
\title{Get levels table}
\usage{
get_levels(study, release = "latest", vars = NULL, tables = NULL)

get_levels_abcd(...)

get_levels_hbcd(...)
}
\arguments{
\item{study}{character. The study name. One of "abcd" or "hbcd".}

\item{release}{character. Release version (Default: \code{"latest"}).}

\item{vars}{character (vector). Vector with the names of variables to be
included.}

\item{tables}{character (vector). Vector with the names of tables to be
included.}

\item{...}{Additional arguments passed to the underlying
\code{\link[=get_levels]{get_levels()}} function.}
}
\value{
Data frame with the levels table.
}
\description{
Retrieves levels table for a given study and release version. Allows for
filtering by variables and tables. Wrapper around
\code{\link[=get_metadata]{get_metadata()}}.

In addition to the main \code{get_levels()} function, there are two
study-specific variations:
\itemize{
\item \code{get_levels_abcd()}: for the ABCD study.
\item \code{get_levels_hbcd()}: for the HBCD study.
}

They have the same arguments as the \code{get_levels()} function, except
that the \code{study} argument is set to the respective study by default, and
should not be set by the user.
}
\examples{
get_levels("abcd")

get_levels("hbcd", release = "1.0")

get_levels("abcd", vars = c("ab_g_dyn__visit_type"))

get_levels("abcd", tables = "ab_g_dyn")

get_levels_abcd(release = "6.0")

get_levels_hbcd()
}
