% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOpt.R
\name{SpecificMLEInputs}
\alias{SpecificMLEInputs}
\title{Concatenate the model-specific inputs in a list}
\usage{
SpecificMLEInputs(
  ModelType,
  Economies,
  RiskFactors,
  FactorLabels,
  GVARlist = NULL,
  JLLlist = NULL,
  WishBRW = 0,
  BRWlist = NULL
)
}
\arguments{
\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{Economies}{string-vector containing the names of the economies of the system}

\item{RiskFactors}{time series of risk factors (F x T)}

\item{FactorLabels}{string-list based which contains the labels of all the variables present in the model}

\item{GVARlist}{A list of required inputs to estimate the GVAR-based setups:
\enumerate{
     \item VARXtype  string-vector containing the VARX feature (see "GVAR" function) (GVAR-based models)
     \item t_First_Wgvar Sample starting date (year) (GVAR-based models)
     \item t_Last_Wgvar  Sample last date (year) (GVAR-based models)
     \item W_type  Criterion used in the computation of the star variables (see "Transition_Matrix" function)
              (GVAR-based models)
 }}

\item{JLLlist}{A list of required inputs to estimate the JLL-based setups:
\enumerate{
     \item DomUnit name of the economy which is assigned as the dominant unit (JLL-based models)
     \item WishSigmas equal to "1" if one wishes the variance-covariance matrices and the Cholesky factorizations (JLL-based models)
     \item SigmaNonOrtho NULL or some F x F matrix from the non-orthogonalized dynamics (JLL-based models)
}}

\item{WishBRW}{Whether the user wishes to estimate the physical parameter model with the Bias correction model from BRW (2012) (see "Bias_Correc_VAR" function).\cr
Default is set to 0.}

\item{BRWlist}{A list of required inputs to estimate the bias corrected setups of the type of BRW:
\enumerate{
     \item BiasCorrection binary variable. it takes value equal to 1 if the user whishes the estimates to be bias-corrected
                     and 0, otherwise. (BRW model)
     \item flag_mean flag whether mean- (TRUE) or median- (FALSE) unbiased estimation is desired
     \item gamma adjustment parameter (BRW model)
     \item N_iter number of iterations (BRW model)
     \item N_burn number of burn-in iterations (BRW model)
     \item B  number of bootstrap samples (BRW model)
     \item checkBRW flag whether the user wishes to perform the closeness check (BRW model)
     \item B_check number of bootstrap samples for closeness check
}}
}
\description{
Concatenate the model-specific inputs in a list
}
\keyword{internal}
