#' @title Data: bond yield data - Candelon and Moura (2024, JFEC)
#'
#' @description Yields data used in Candelon and Moura (2024, JFEC)
#' @name Yields
#' @aliases Yields
#' @docType data
#' @usage data("Yields")
#' @format A matrix containing bond yields with maturities of 3, 6, 12, 36, 60, and 120 months for Brazil, China, Mexico, and Uruguay.
#' The data are at monthly frequency and cover the period from June 2004, to January 2020.
#' @source
#' \describe{
#' \item{Brazil}{Swap fixed-DI contracts (derivative securities indexed to the interbank loan rates). <https://www.b3.com.br/pt_br/market-data-e-indices/servicos-de-dados/market-data/consultas/mercado-de-derivativos/precos-referenciais/taxas-referenciais-bm-fbovespa/>}
#' \item{China}{Government bond yield data in domestic currency. Simulated data constructed using Bloomberg bond yield series.}
#' \item{Mexico}{Government bond yield data in domestic currency. Simulated data constructed using Bloomberg bond yield series.}
#' \item{Uruguay}{Government bond yield data in US dollars <https://web.bevsa.com.uy/CurvasVectorPrecios/CurvasIndices/CUD.aspx>.}
#' }
#' @references Candelon, B. and Moura, R. (2024) "A Multicountry Model of the Term Structures of Interest Rates with a GVAR". (Journal of Financial Econometrics)
#' @keywords Bond yields
NULL
