#'@title Replications of the JPS (2014) outputs by Bauer and Rudebusch (2017)
#'
#' @description Unspanned macro risk model outputs by Bauer and Rudebusch (2017)
#' @name BR_jps_out
#' @docType data
#' @usage data("BR_jps_gro_R3")
#' @format Unspanned macro risk model outputs by Bauer and Rudebusch (2017)
#' \describe{
#' \item{est.llk}{summary list of log-likelihood estimations}
#'    \item{M.o}{time series of unspanned factors}
#'    \item{pars}{additional summary list of log-likelihood estimations}
#'    \item{W}{Weight matrix that results from principal components analysis}
#'    \item{Y}{time series of bond yields}
#'    \item{N}{total number of  risk factor of the model (spanned and unspanned)}
#'    \item{R}{total number of  spanned factor of the model}
#'   }
#' @references Bauer, M. and Rudebusch, G. "Resolving the Spanning Puzzle in Macro-Finance Term Structure Models"
#' @keywords JPS (2014) outputs
NULL
