% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastKmeans.r
\name{fastKmeans}
\alias{fastKmeans}
\title{fast kmeans clustering for 2D or 3D point clouds}
\usage{
fastKmeans(x, k, iter.max = 10, project = TRUE, threads = 0)
}
\arguments{
\item{x}{matrix containing coordinates or mesh3d}

\item{k}{number of clusters}

\item{iter.max}{maximum number of iterations}

\item{project}{logical: if x is a triangular mesh, the centers will be projected onto the surface.}

\item{threads}{integer number of threads to use}
}
\value{
returns a list containing
\item{selected}{coordinates closest to the final centers}
\item{centers}{cluster center}
\item{class}{vector with cluster association for each coordinate}
}
\description{
fast kmeans clustering for 2D or 3D point clouds - with the primary purpose to get a spatially equally distributed samples
}
\examples{
require(Rvcg)
data(humface)
set.seed(42)
clust <- fastKmeans(humface,k=1000,threads=1)
\dontrun{
require(rgl)

## plot the cluster centers
spheres3d(clust$centers)

## now look at the vertices closest to the centers
wire3d(humface)
spheres3d(vert2points(humface)[clust$selected,],col=2)
}


}
