% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defun2011.R
\name{defun2011}
\alias{defun2011}
\title{Download data for deaths from INE}
\usage{
defun2011(file)
}
\arguments{
\item{file}{Character string with the name of the microdata file provided by the INE on the
\href{http://www.ine.es/dyngs/INEbase/es/operacion.htm?c=Estadistica_C&cid=1254736177008&menu=resultados&secc=1254736195450&idp=1254735573002}{Deaths} section. It allows either a path to a file
or literal data (single string or raw vector). It also allows compressed files in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} format.}
}
\value{
\code{\link[tibble]{tibble}} with all avaliable requested data where each row corresponds to an anonymised citizen.
}
\description{
This function downloads deaths statistcs from the Spanish Statistical Office (INE).
}
\details{
This function reads deaths microdata in Spain.

It was originally built using the metadata for the 2011 file and may work with microdata files for other yearly submissions. Previous files have a different, non compatible, format.
}
\note{
The \code{file} parameter allows any flat file with fixed width.
}
\examples{
\dontrun{
raw <- defun2011("datos_2016.zip") # It will be automatically uncompressed.
summary(raw)
}
}
\references{
http://www.ine.es/prodyser/microdatos.htm
}
\seealso{
\code{\link[readr]{read_fwf}} to read fixed width files.
}
\author{
Carlos J. Gil Bellosta
}
