% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{mex_income_2008_tbl_df}
\alias{mex_income_2008_tbl_df}
\title{Mexican Income Data (2008)}
\format{
A tibble with 5,000 observations and 8 variables:
\describe{
  \item{hh_number}{Household ID (character)}
  \item{factor}{Expansion factor (integer)}
  \item{income}{Household income (numeric)}
  \item{hh_structure}{Household structure (factor with 5 levels)}
  \item{education}{Education level of household members (factor with 11 levels)}
  \item{domicile_size}{Size of domicile (factor with 4 levels)}
  \item{age}{Age of household head (integer)}
  \item{age_cat}{Categorical age group (factor with 7 levels)}
}
}
\source{
Data taken from the dineq package version 0.1.0
}
\usage{
data(mex_income_2008_tbl_df)
}
\description{
This dataset, mex_income_2008_tbl_df, is a tibble containing household-level income data and
associated demographic characteristics from the 2008 ENIGH (Household Income and Expenditure Survey)
in Mexico. The dataset includes 5,000 observations and 8 variables, covering household number,
income, household composition, education, domicile size, and age categories.
}
\details{
The dataset name has been kept as 'mex_income_2008_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MexicoDataAPI package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble data frame. The original content has not been modified
in any way.
}
