% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.calculate.R
\name{fast_cor}
\alias{fast_cor}
\title{Fast correlation calculation}
\usage{
fast_cor(totu, totu2 = NULL, method = c("pearson", "spearman"))
}
\arguments{
\item{totu}{t(otutab), row are samples, column are features.}

\item{totu2}{t(otutab) or NULL, row are samples, column are features.}

\item{method}{"spearman" or "pearson"}
}
\value{
a list with 2 elements:
\item{r}{default: spearman correlation}
\item{p.value}{default: p-value of spearman correlation}
}
\description{
Fast correlation calculation
}
\examples{
data("otutab", package = "pcutils")
t(otutab[1:100, ]) -> totu
fast_cor(totu, method = "spearman") -> corr
}
\seealso{
Other calculate: 
\code{\link{c_net_calculate}()},
\code{\link{cal_sim}()},
\code{\link{p.adjust.table}()},
\code{\link{read_corr}()}
}
\concept{calculate}
