% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2pedgene.R
\name{DOpedgene}
\alias{DOpedgene}
\title{pedgene call back function}
\usage{
DOpedgene(markers_arg, range_arg, envir = ENV)
}
\arguments{
\item{markers_arg}{a data.frame with the following 5 observations:
\describe{
\item{locus_link}{is the ordinal ranking of this marker among all loci}
\item{locus_link_fill}{is the position of corresponding genotype data in the
\emph{unified_genotype_table}}
\item{MarkerName}{is the text name of the marker}
\item{chromosome}{is the integer chromosome number}
\item{position}{is the integer base pair position of marker}
 }}

\item{range_arg}{one row of a ranges_arg.  The latter is a data frame of at least three
integer columns.  The columns indicate a range:
a chromosome number, a start base pair value, and an end base pair value.}

\item{envir}{'environment' containing SQLite database and other globals}
}
\value{
None
}
\description{
First, ignore call backs that have less than two markers.  Second, convert the genotypesraw()
 patterns of 0x10001, 0x10002 (or 0x20001), 0x20002, 0 from the genotype matrix
 to the numbers 0, 1, 2, 0 for each marker. (Reverse, the order iff allele "1" has the
 minor allele frequency.)  Next, prepend the pedigree and person columns of the family data
 to this modified genotype matrix.  Finally, invoke \code{pedgene} with the family data and
 genotype matrix for several different weights.  Save the kernel and burden, value and p-value for each
 measurement in \emph{envir$pedgene_results}.
}
\note{
This function appends output to the data frame, \emph{envir$pedgene_results}.  It will
 print out the lines as they are generated if \emph{envir$verbose} is TRUE. The data frame
 \emph{envir$pedgene_results} is initialized by \emph{init_pedgene}, and is appended to
 each time \emph{DOpedgene} is run.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = init_pedgene(db)
# ENV$verbose = TRUE
applyFnToRanges(DOpedgene, ENV$refRanges[50:60,], ENV$refIndices)

# try this below if there is time
# applyFnToGenes(DOpedgene, genes_arg = c("CEP104"))

}
\seealso{
\code{\link{init_pedgene}}
}
