\name{GetQualificationType}
\alias{GetQualificationType}
\alias{qualtype}
\title{Get QualificationType}
\description{Get the details of a Qualification Type.}
\usage{
GetQualificationType(qual, verbose = getOption('MTurkR.verbose'), ...)
}
\arguments{
  \item{qual}{A character string containing a QualificationTypeId.}
  \item{verbose}{Optionally print the results of the API request to the standard output. Default is taken from \code{getOption('MturkR.verbose')}.}
  \item{...}{Additional arguments passed to \code{\link{request}}.}
}
\details{
Retrieve characteristics of a specified QualificationType (as originally specified by \code{\link{CreateQualificationType}}).

\code{qualtype()} is an alias.
}
\value{A dataframe containing the QualificationTypeId of the newly created QualificationType and other details as specified in the request.}
\references{
\href{http://docs.amazonwebservices.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html}{API Reference}
}
\author{Thomas J. Leeper}
%\note{}
\seealso{
\code{\link{CreateQualificationType}}

\code{\link{UpdateQualificationType}}

\code{\link{DisposeQualificationType}}

\code{\link{SearchQualificationTypes}}
}
\examples{
\dontrun{
GetQualificationType("2YCIA0RYNJ9262B1D82MPTUEXAMPLE")
}
}
\keyword{Qualifications}