%  Copyright (C) 2015 Christian Margreitter
\name{TIcurve}
\alias{TIcurve}
\title{Thermodynamic integration plot}
\description{Plot the thermodynamic integration(s) (TI) specified in the input files. Files have to have three columns (lambda point, free energy and error) in order to be valid. In addtion, the delta free energies are calculated (to a precision dependent on the error size) and the hysteresis is calculated in case a forward and backward simulation have been performed.}
\usage{
TIcurve( lambdas,
         invertedBackwards = FALSE,
         energyUnit = "kJ/mol",
         printValues = TRUE,
         barePlot = FALSE,
         ... )}
\arguments{
  \item{lambdas}{List of matrices (automatically generated by \code{\link{load_TIcurve}()}) holding the thermodynamic integration information. For the file format, see the description.}
  \item{invertedBackwards}{In case a forward and backward TI have been performed and the lambda points are enumerated reversely (i.e. 0.3 of one TI is equivalent to 0.7 of the other), this flag can be set to be \code{TRUE} in order to automatically mirror the values appropriately.}
  \item{energyUnit}{Defines the energy unit used for the plot.}
  \item{printValues}{Boolean, indicating whether the computed values are to be plotted.}
  \item{barePlot}{Boolean, indicating whether the plot is to be made without any additional information.}
  \item{...}{Additional arguments (ellipsis).}
}
\examples{
# see "extdata/TIcurve_example.txt.gz" for format information
TIcurve( load_TIcurve( system.file( "extdata/TIcurve_example.txt.gz",
                                    package = "MDplot" ) ) )

# forward and backward integration
TIcurve( load_TIcurve( c( system.file( "extdata/TIcurve_fb_forward_example.txt.gz",
                                       package = "MDplot" ),
                          system.file( "extdata/TIcurve_fb_backward_example.txt.gz",
                          package = "MDplot" ) ) ),
         invertedBackwards = TRUE )
}
\author{Christian Margreitter}
\keyword{Thermodynamic integration}
