% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lorenz-graphs.R
\name{Lorenz.graphs}
\alias{Lorenz.graphs}
\title{Graphs of concentration curves}
\usage{
Lorenz.graphs(formula, data, difference = FALSE, ...)
}
\arguments{
\item{formula}{A formula object of the form \emph{response} ~ \emph{other_variables}. The form \emph{response} ~ \emph{1} is used to display only the Lorenz curve of the response.}

\item{data}{A dataframe containing the variables of interest}

\item{difference}{A logical determining whether the vertical axis should be expressed in terms of deviation from perfect equality. Default is \code{FALSE}.}

\item{...}{Further arguments (see Section 'Arguments' in \code{\link{Lorenz.curve}}).}
}
\value{
A plot comprising
\itemize{
   \item The Lorenz curve of \emph{response}
   \item The concentration curves of \emph{response} with respect to each element of \emph{other_variables}
}
}
\description{
\code{Lorenz.graphs} traces the Lorenz curve of a response and the concentration curve of the response and each of a series of covariates.
}
\examples{
data(Data.Incomes)
Lorenz.graphs(Income ~ Age + Work.Hours, data = Data.Incomes)
# Expressing now the vertical axis as the deviation from perfect equality
Lorenz.graphs(Income ~ Age + Work.Hours, data = Data.Incomes, difference = TRUE)

}
\seealso{
\code{\link{Lorenz.curve}}, \code{\link{Gini.coef}}
}
