% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hessian.R
\name{hessian}
\alias{hessian}
\title{Hessian Matrix}
\usage{
hessian(f, x0, ...)
}
\arguments{
\item{f}{(type: numeric) name of function that defines log likelihood
(or negative of it).}

\item{x0}{(type: numeric) scalar or vector of parameters that give the point
at which you want the hessian estimated (usually will be the mle).}

\item{...}{Additional arguments to be passed to the function.}
}
\value{
An \eqn{n \times n} matrix of 2nd derivatives, where \eqn{n} is the length of
\code{x0}.
}
\description{
Numerical aproximation of the Hessian of a function.
}
\details{
Computes the numerical approximation of the Hessian of \code{f}, evaluated at
\code{x0}.
Usually needs to pass additional parameters (e.g. data).  N.B. this uses no
numerical sophistication.
}
\examples{
# Variance of the maximum likelihood estimator for mu parameter in
# gaussian data
loglik <- function(series, x, sd = 1) {
  -sum(log(dnorm(series, mean = x, sd = sd)))
}
sqrt(c(var(malleco) / length(malleco), diag(solve(hessian(
  f = loglik, x = mean(malleco), series = malleco,
  sd = sd(malleco)
)))))
}
\seealso{
\code{\link{arima.sim}}
}
