% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParallelTest.R
\name{ParallelTest}
\alias{ParallelTest}
\title{Testing for a Pareto tail}
\usage{
ParallelTest(nboot, y, obsTest, minRank)
}
\arguments{
\item{nboot}{number of bootstrap replications.}

\item{y}{observed data.}

\item{obsTest}{value of the test statistics computed with the data under analysis.}

\item{minRank}{minimum possible rank of the threshold.}
}
\value{
A list with the following elements:

LR: nboot simulated values of the llr test under the null hypothesis.

pval: p-value of the test.
}
\description{
This function computes the bootstrap test for the null hypothesis of
a pure lognormal distribution versus the alternative of a lognormal-Pareto
mixture. Implemented via parallel computing.
}
\examples{
\donttest{minRank = 90
mixFit <- LPfit(TN2016,minRank,0)
ell1 <- mixFit$loglik
estNull <- c(mean(log(TN2016)),sd(log(TN2016)))
ellNull <- sum(log(dlnorm(TN2016,estNull[1],estNull[2])))
obsTest <- 2*(ell1-ellNull)
nboot = 2
TestRes = ParallelTest(nboot,TN2016,obsTest,minRank)}
}
\keyword{likelihood;}
\keyword{log-likelihood}
\keyword{mixture;}
\keyword{profile}
\keyword{ratio}
\keyword{test.}
