% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImgSeg.R
\name{GenImg}
\alias{GenImg}
\title{Generate black-and-white images}
\usage{
GenImg(nx, ny, Type = 1, bNoise = FALSE, sig_noise = 0.1)
}
\arguments{
\item{nx}{- Width of an image.}

\item{ny}{- Length of an image.}

\item{Type}{- Type of an image: 1, 2, and 3 for rectangle, circle, and random dots, respectively.}

\item{bNoise}{- Option for including noise: TRUE or FALSE.}

\item{sig_noise}{- Strength of noise: numeric value between 0 and 0.5.}
}
\value{
A list of information of a generated image.
\itemize{
 \item ImgMat - a matrix whose entries are pixel values of a generated image.
 \item S1 - an n1x2 matrix whose entries denote coordinates of white pixels of the image. n1 denotes the number of the white pixels.
 \item S2 - an n2x2 matrix whose entries denote coordinates of black pixels of the image. n2 denotes the number of the black pixels.
}
}
\description{
Create various images such as circle, rectangle and random dots.
}
\examples{


######## Generate a 10x10 black-and-white rectangle image with some noise
nx=10
ny=10
Type=1
bNoise=TRUE
sig_noise=0.1
lst = GenImg(nx,ny,Type, bNoise, sig_noise)
ImgMat = lst$ImgMat
image(ImgMat, axes = FALSE, col = grey(seq(0, 1, length = 256)))



}
