% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{moments}
\alias{moments}
\title{Estimate the first and second moments}
\usage{
moments(data, ...)
}
\arguments{
\item{data}{A data frame or an object coercable to a data frame.
The means and covariances of all variables are estimated.}

\item{\dots}{Additional arguments passed on to the \code{estimate.moments.EM}
function in \pkg{lavaan}. Note this is not an exported function.}
}
\value{
A list containing the esimates from the EM algorithm.
  \item{mu}{A named vector of the means.}
  \item{sigma}{The covariance matrix.}
}
\description{
This function relies on the \pkg{lavaan} package to use the
Expectation Maximization (EM) algorithm to estimate the first and
second moments (means and [co]variances) when there is missing data.
}
\examples{
# sample data
Xmiss <- as.matrix(iris[, -5])
# make 25\% missing completely at random
set.seed(10)
Xmiss[sample(length(Xmiss), length(Xmiss) * .25)] <- NA
Xmiss <- as.data.frame(Xmiss)

# true means and covariance
colMeans(iris[, -5])
# covariance with n - 1 divisor
cov(iris[, -5])

# means and covariance matrix using list wise deletion
colMeans(na.omit(Xmiss))
cov(na.omit(Xmiss))

# means and covariance matrix using EM
moments(Xmiss)
# clean up
rm(Xmiss)
}
\seealso{
\code{\link{SEMSummary}}
}
\author{
Suggested by Yves Rosseel author of the lavaan 
  package on which this depends
}
\keyword{multivariate}
