% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportingfunctions.R
\name{evaluate}
\alias{evaluate}
\title{Evaluation for estimated cell type proportions}
\usage{
evaluate(est.prop,true.prop)
}
\arguments{
\item{est.prop}{The estimated cell type proportions.}

\item{true.prop}{The True cell type proportions}
}
\value{
Cell-type level evaluations based on MAD, Ken, and Pearson (`cell.type.eva`), and overall evaluations based on averaged MAD, Ken, and Pearson (`all.eva`).
}
\description{
Several evaluation metrics are provided, such as mean absolute deviance (`MAD`), Kendall-tau correlation coefficient (`Ken`), Pearson correlation coefficient (`Cor`), given true cell type proportions.
}
\examples{
##read data
library(InteRD)
readRDSFromWeb<-function(ref) {readRDS(gzcon(url(ref)))}
urlremote<-"https://github.com/chencxxy28/Data/raw/main/data_InteRD/"
pseudo.seger<-readRDSFromWeb(paste0(urlremote,"pseudo.seger.rds"))
true_p<-readRDSFromWeb(paste0(urlremote,"true_p.rds"))
SCDC_ENSEMBLE_MAD<-readRDSFromWeb(paste0(urlremote,"SCDC_ENSEMBLE_MAD_seger.rds"))
evaluate(SCDC_ENSEMBLE_MAD,true_p)$all.eva
}
