% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc-methods.R
\docType{methods}
\name{auc-methods}
\alias{auc-methods}
\alias{auc}
\alias{auc,bincap-method}
\alias{auc,multcap-method}
\title{Methods for Function \code{auc} in Package \pkg{HandTill2001}}
\usage{
\S4method{auc}{bincap}(object)

\S4method{auc}{multcap}(object)
}
\arguments{
\item{object}{An object of \code{class} \emph{bincap} or \emph{multcap}.}
}
\value{
An object of class \code{"numeric"}.
}
\description{
Calculate area under curve of the receiver operating characteristic for
two or more prediction classes.
}
\details{
Depending on whether \code{object} is of class \code{bincap} or of class
\code{multcap}, a binary class or multiple class AUC is calculated.
}
\section{Methods}{
 \describe{

\item{signature(object = "bincap")}{ calculates the AUC statistic
for a binary class response following \cite{Hand and Till (2001)}, Eq. (3). }

\item{signature(object = "multcap")}{ calculates the AUC statistic
for a multiple class response following \cite{Hand and Till (2001)}, Eq.
(7). } }
}

\examples{
data(ht01.twoclass, package = "HandTill2001")
message(" == AUC for a binary class response")
message(" == == HandTill2001 result:")
HandTill2001::auc(HandTill2001::bincap(
  response = as.factor(ht01.twoclass[["observed"]]),
  predicted = ht01.twoclass[["predicted"]],
  true = "1"
))
\dontrun{
message(" == == ROCR result:")
ROCR::performance(ROCR::prediction(
  labels = ht01.twoclass[["observed"]],
  predictions = ht01.twoclass[["predicted"]]
),
measure = "auc"
)@y.values
}
data(ht01.multipleclass, package = "HandTill2001")
message(" == AUC for a multiple class response")
predicted <- as.matrix(ht01.multipleclass[, levels(ht01.multipleclass[["observed"]])])
HandTill2001::auc(HandTill2001::multcap(
  response = ht01.multipleclass[["observed"]],
  predicted = predicted
))
}
\references{
\cite{David J. Hand and Robert J. Till (2001). A Simple
Generalisation of the Area Under the ROC Curve for Multiple Class
Classification Problems. \emph{Machine Learning} \bold{45}(2), p. 171--186.
DOI:
\doi{10.1023/A:1010920819831}}.
}
\seealso{
\code{\link[=bincap-class]{class?bincap}},
\code{\link[=multcap-class]{class?multcap}}
}
\keyword{auc}
\keyword{methods}
