% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printCrudeAndAdjustedModel.R
\name{caDescribeOpts}
\alias{caDescribeOpts}
\title{A function for gathering all the description options}
\usage{
caDescribeOpts(
  show_tot_perc = FALSE,
  numb_first = TRUE,
  continuous_fn = describeMean,
  prop_fn = describeFactors,
  factor_fn = describeFactors,
  digits = 1,
  colnames = c("Total", "Event")
)
}
\arguments{
\item{show_tot_perc}{Show percentages for the total column}

\item{numb_first}{Whether to show the number before the percentages}

\item{continuous_fn}{Stat function used for the descriptive statistics,
defaults to \code{\link{describeMean}()}}

\item{prop_fn}{Stat function used for the descriptive statistics,
defaults to \code{\link{describeFactors}()} since there has to be a reference
in the current setup.}

\item{factor_fn}{Stat function used for the descriptive statistics,
defaults to \code{\link{describeFactors}()}}

\item{digits}{Number of digits to use in the descriptive columns.
Defaults to the general digits if not specified.}

\item{colnames}{The names of the two descriptive columns. By default
Total and Event.}
}
\value{
\code{list} Returns a list with all the options
}
\description{
Since there are so many different description options
for the \code{\link{printCrudeAndAdjustedModel}()} function they
have been gathered into a list. This function is simply a
helper in order to generate a valid list.
}
