% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MagnitudeRule.R
\name{MagnitudeRule}
\alias{MagnitudeRule}
\alias{DominanceRule}
\alias{PPercentRule}
\title{Dominance \verb{(n,k)} or p\% rule for magnitude tables}
\usage{
MagnitudeRule(
  data,
  x,
  numVar,
  n = NULL,
  k = NULL,
  pPercent = NULL,
  protectZeros = FALSE,
  charVar = NULL,
  removeCodes = character(0),
  removeCodesFraction = 1,
  sWeightVar = NULL,
  domWeightMethod = "default",
  allDominance = FALSE,
  outputWeightedNum = !is.null(sWeightVar),
  dominanceVar = NULL,
  structuralEmpty = FALSE,
  apply_abs_directly = FALSE,
  max_contribution_output = NULL,
  num,
  protectionIntervals = FALSE,
  intervalVar = dominanceVar,
  ...
)

DominanceRule(data, n, k, protectZeros = FALSE, ...)

PPercentRule(data, pPercent, protectZeros = FALSE, ...)
}
\arguments{
\item{data}{the dataset}

\item{x}{ModelMatrix generated by parent function}

\item{numVar}{vector containing numeric values in the data set}

\item{n}{Parameter \code{n} in dominance rule.}

\item{k}{Parameter \code{k} in dominance rule.}

\item{pPercent}{Parameter in the p\% rule, when non-NULL.
Parameters \code{n} and  \code{k} will then be ignored.
Technically, calculations are performed internally as if
\code{n = 1:2}. The results of these intermediate calculations can
be viewed by setting \code{allDominance = TRUE}.}

\item{protectZeros}{Parameter determining whether cells with value 0 should
be suppressed.
Unless \code{structuralEmpty} is \code{TRUE} (see below), cells that result in a value
of 0 due to removed \code{removeCode} contributions are also suppressed.}

\item{charVar}{Variable in data holding grouping information. Dominance will
be calculated after aggregation within these groups.}

\item{removeCodes}{A vector of \code{charVar} codes that are to be excluded when
calculating dominance percentages. Essentially, the corresponding numeric
values from \code{dominanceVar} or \code{numVar} are set to zero before proceeding
with the dominance calculations. With empty \code{charVar} row indices are
assumed and conversion to integer is performed.
See also \code{removeCodesFraction} below.}

\item{removeCodesFraction}{Numeric value(s) in the range \verb{[0, 1]}.
This can be either a single value or a vector with the same length as \code{removeCodes}.
A value of 1 represents the default behavior, as described above.
A value of 0 indicates that dominance percentages are calculated as if \code{removeCodes}
were not removed, but percentages associated with \code{removeCodes} are still excluded
when identifying major contributions. Values between 0 and 1 modify the
contributions of \code{removeCodes} proportionally in the calculation of percentages.}

\item{sWeightVar}{variable with sampling weights to be used in dominance rule}

\item{domWeightMethod}{character representing how weights should be treated
in the dominance rule. See Details.}

\item{allDominance}{Logical. If \code{TRUE}, additional information is included in the output.
When \code{n = 2}, the following variables are added:
\itemize{
\item \code{"dominant2"}: The fraction associated with the dominance rule.
\item \code{"max2contributor"}: IDs associated with the second largest contribution. These IDs
are taken from \code{charVar} if provided, or the row indices if \code{charVar} is not supplied.
\item \code{"n_contr"} and \code{"n_non0_contr"}: Outputs from \code{\link[SSBtools]{max_contribution}}.
If \code{removeCodes} is used as input, \code{"n_contr_all"} and \code{"n_non0_contr_all"} are also included.
The parameter \code{max_contribution_output} can be used to specify custom outputs
from \code{\link[SSBtools]{max_contribution}}. Note that if \code{max_contribution_output}
is provided, only the specified outputs will be included, and the default outputs
(\code{"n_contr"} and \code{"n_non0_contr"}) will not be added unless explicitly listed.
}}

\item{outputWeightedNum}{logical value to determine whether weighted numerical
value should be included in output. Default is \code{TRUE} if \code{sWeightVar} is provided.}

\item{dominanceVar}{When specified, \code{dominanceVar} is used in place of \code{numVar}.
Specifying \code{dominanceVar} is beneficial for avoiding warnings when there
are multiple \code{numVar} variables. Typically, \code{dominanceVar} will be one
of the variables already included in \code{numVar}.}

\item{structuralEmpty}{Parameter as input to \code{\link{GaussSuppressionFromData}}.
It is needed also here to handle structural zeros caused by \code{removeCodes}.}

\item{apply_abs_directly}{Logical. Determines how negative values are treated in the rules.
When \code{apply_abs_directly = FALSE} (default), absolute values are taken after summing
contributions, as performed by \code{\link[SSBtools]{max_contribution}}.
When \code{apply_abs_directly = TRUE}, absolute values are computed directly on the input values,
prior to any summation. This corresponds to the old behavior of the function.}

\item{max_contribution_output}{See the description of the \code{allDominance} parameter.}

\item{num}{Output numeric data generated by parent function.
This parameter is needed when \code{protectZeros} is \code{TRUE}.}

\item{protectionIntervals}{Logical. When \code{TRUE}, symmetric interval
requirements from dominance rules or the p\% rule are included in the output.
Calculated according to formulas for upper protection levels
in \emph{Handbook on Statistical Disclosure Control} (2nd ed., Ch. 4.2.2, 2025).
The corresponding variables are added with names starting
with \code{lomax_} and \code{upmin_}.}

\item{intervalVar}{Numerical variable for interval calculations.}

\item{...}{unused parameters}
}
\value{
logical vector that is \code{TRUE} in positions corresponding to cells
breaching the dominance rules.
}
\description{
Supports application of multiple values for \code{n} and \code{k}. The function works
on magnitude tables containing negative cell values by calculating
contribution based on absolute values.
}
\details{
This method only supports suppressing a single numeric variable. There are
multiple ways of handling sampling weights in the dominance rule. the default
method implemented here compares unweighted sample values with the corresponding
weighted cell totals. if \code{domWeightMethod} is set to \code{"tauargus"}, the
method implemented in tauArgus is used. For more information on this
method, see "Statistical Disclosure Control" by Hundepool et al (2012,
p. 151).
}
\note{
Explicit  \code{protectZeros} in wrappers
since default needed by \code{\link{GaussSuppressionFromData}}
}
\examples{
  set.seed(123)
z <- SSBtools::MakeMicro(SSBtoolsData("z2"), "ant")
z$value <- sample(1:1000, nrow(z), replace = TRUE)

GaussSuppressionFromData(z, dimVar = c("region", "fylke", "kostragr", "hovedint"), 
numVar = "value", candidates = CandidatesNum, primary = DominanceRule, preAggregate = FALSE,
singletonMethod = "sub2Sum", n = c(1, 2), k = c(65, 85), allDominance = TRUE)


num <- c(100,
         90, 10,
         80, 20,
         70, 30,
         50, 25, 25,
         40, 20, 20, 20,
         25, 25, 25, 25)
v1 <- c("v1",
        rep(c("v2", "v3", "v4"), each = 2),
        rep("v5", 3),
        rep(c("v6", "v7"), each = 4))
sw <- c(1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1)
d <- data.frame(v1 = v1, num = num, sw = sw)

# without weights
GaussSuppressionFromData(d, formula = ~v1 - 1, 
 numVar = "num",  n = c(1,2), k = c(80,70),
  preAggregate = FALSE, allDominance = TRUE, candidates = CandidatesNum,
  primary = DominanceRule)

# with weights, standard method
GaussSuppressionFromData(d, formula = ~v1 - 1,
 numVar = "num",  n = c(1,2), k = c(80,70), sWeightVar = "sw",
 preAggregate = FALSE, allDominance = TRUE, candidates = CandidatesNum,
 primary = DominanceRule)

# with weights, tauargus method
GaussSuppressionFromData(d, formula = ~v1 - 1,
 numVar = "num",  n = c(1,2), k = c(80,70), sWeightVar = "sw",
 preAggregate = FALSE, allDominance = TRUE, candidates = CandidatesNum,
 primary = DominanceRule, domWeightMethod = "tauargus")

}
\author{
Daniel Lupp and Øyvind Langsrud
}
