% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_.R
\name{plot_hubs}
\alias{plot_hubs}
\title{Plot Transit Hubs}
\usage{
plot_hubs(gtfs, i = 0.05)
}
\arguments{
\item{gtfs}{A GTFS object, preferably of class `wizardgtfs`. If not, the function will attempt to convert it using `GTFSwizard::as_wizardgtfs()`.}

\item{i}{A numeric value representing the percentile threshold for selecting high-density stops. Defaults to `0.05` (top 5\% of stops by number of routes).}
}
\value{
A `ggplot` object representing the transit network with hubs overlaid. The plot includes:
\describe{
  \item{Base map}{Route shapes from the GTFS data, displayed in gray.}
  \item{Hubs}{High-density transit stops.}
}
}
\description{
The `plot_hubs` function visualizes high-density potential integration transit stops (hubs) on a map. It overlays the identified stops
on the route shapes from the GTFS data, providing a representation of the transit network and its key integration hubs.
}
\note{
Ensure the `gtfs` object includes valid `shapes` and `stop_times` tables for accurate visualization. The hubs are identified
using the `get_hubs` function, which relies on stop and trip data.
}
\examples{
plot_hubs(for_bus_gtfs, i = 0.02)


}
\seealso{
[GTFSwizard::get_hubs()], [GTFSwizard::get_shapes_sf()]
}
