% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_grm.r
\name{runGRM}
\alias{runGRM}
\title{Run graded response model}
\usage{
runGRM(dat, lav.syntax, estimator)
}
\arguments{
\item{dat}{a data frame containing graded response model data}

\item{lav.syntax}{a character indicating \code{\link{lavaan}} syntax}

\item{estimator}{a character indicating the type of estimator.
\itemize{
\item{\code{ML}} Maximum likelihood estimation
\item{\code{WL}} Weighted least squares mean and variance
}}
}
\value{
a list containing GRM results as follows:
\itemize{
  \item{\code{fit}} an object from either \code{\linkS4class{SingleGroupClass}}
   from \code{\link{mirt}} or code{\linkS4class{lavaan}} from from
    \code{\link{lavaan}}.
  \item{\code{grm.par}} a data frame indicating graded response parameters.
}
}
\description{
Run graded response model
}
\details{
This conducts GRM. The second element of the return indicates
the graded response parameters converted from the CFA parameters
}
