% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{run_mcmc}
\alias{run_mcmc}
\title{Main function implemented in C++ for the MCMC loop}
\usage{
run_mcmc(
  nIter,
  burnin,
  thin,
  n,
  nsamp,
  ninit,
  metropolis,
  simple,
  convex,
  npoint,
  dirichlet,
  proportion_model,
  BVS,
  gamma_prior,
  gamma_sampler,
  eta_prior,
  eta_sampler,
  initList,
  rangeList,
  hyperparList,
  datEvent,
  datTime,
  datX,
  datX0,
  datProportionConst
)
}
\arguments{
\item{nIter}{number of MCMC iterations}

\item{burnin}{length of MCMC burn-in period}

\item{thin}{number of thinning}

\item{n}{number of samples to draw}

\item{nsamp}{how many samples to draw for generating each sample; only the last draw will be kept}

\item{ninit}{number of initials as meshgrid values for envelop search}

\item{metropolis}{value 0/1 for metropolis step or not}

\item{simple}{logical value for implementing a simple arms algorithm}

\item{convex}{adjustment for convexity (non-negative value, default 1.0)}

\item{npoint}{maximum number of envelope points}

\item{dirichlet}{not yet implemented}

\item{proportion_model}{logical value for modeling the proportions data}

\item{BVS}{logical value for implementing Bayesian variable selection}

\item{gamma_prior}{one of \code{c("bernoulli", "MRF")}}

\item{gamma_sampler}{one of \code{c("mc3", "bandit")}}

\item{eta_prior}{one of \code{c("bernoulli", "MRF")}}

\item{eta_sampler}{one of \code{c("mc3", "bandit")}}

\item{initList}{a list of initial values for parameters "kappa", "xi", "betas", and "zetas"}

\item{rangeList}{a list of ranges of initial values for parameters "kappa", "xi", "betas", and "zetas"}

\item{hyperparList}{a list of relevant hyperparameters}

\item{datEvent}{a vector of survival status}

\item{datTime}{a vector of survival times}

\item{datX}{an array of cluster-specific covariates}

\item{datX0}{a matrix of mandatory variables}

\item{datProportionConst}{an array of cluster-specific proportions}
}
\description{
Main function implemented in C++ for the MCMC loop
}
