% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_GOspecies.R
\name{graphGOspecies}
\alias{graphGOspecies}
\title{Undirected network representation  for the results of functional
 enrichment analysis for one species}
\usage{
graphGOspecies(
  df,
  GOterm_field,
  option = "Categories",
  numCores = 2,
  saveGraph = FALSE,
  outdir = NULL,
  filename = NULL
)
}
\arguments{
\item{df}{A data frame with the results of a functional enrichment analysis for
a species with an extra column "feature" with the features to be compared}

\item{GOterm_field}{This is a string with the column name of the GO terms (e.g: "Functional.Category")}

\item{option}{(values: "GO" or "Categories"). This option allows create either a graph where nodes are GO terms and edges are features or alternatively
a graph where nodes are features and edges are GO terms (default value="Categories")}

\item{numCores}{numeric, Number of cores to use for the process (default value numCores=2). For the example below, only one core will be used}

\item{saveGraph}{logical, if \code{TRUE} the function will allow save the graph in graphml format}

\item{outdir}{This parameter will allow save the graph file in a folder described here (e.g: "D:").This parameter only
works when saveGraph=TRUE}

\item{filename}{The name of the graph filename to be saved in the outdir detailed by the user.This parameter only
works when saveGraph=TRUE}
}
\value{
This function will return a list with two slots: edges and nodes.

 (Categories):
  Edges list columns:
  \tabular{rr}{
  Column \tab Description \cr
  SOURCE and TARGET \tab The source and target categories (Nodes in the edge) \cr
  FEATURES_N \tab The number of GO terms between the categories \cr
  WEIGHT \tab Edge weight \cr
  FEATURES \tab GO terms available for both nodes \cr
  }

  Node list columns:
  \tabular{rr}{
  Column \tab Description \cr
  feature\tab Category name \cr
  GO_count  \tab GO terms counts for the node \cr
  WEIGHT  \tab Node weight \cr
  }

 (GO):

  Edges list columns:
  \tabular{rr}{
  Column \tab Description \cr
  SOURCE and TARGET \tab The source and target GO terms (Nodes in the edge) \cr
  FEATURE \tab The number of Categories where both GO Terms were found \cr
  WEIGHT \tab Edge weight \cr
  }
  Node list columns:

  \tabular{rr}{
  Column \tab Description \cr
  GO \tab GO term node name \cr
  GO_WEIGHT \tab Node weight \cr
  }
}
\description{
graphGOspecies is a function to create undirected graphs using two options:
 \loadmathjax

 Categories option:

 The nodes \mjseqn{(V)} represent groups of gene lists (categories), and the edges \mjseqn{(E)} represent GO terms co-occurring between pairs of categories. More specifically,
 Two categories: \mjseqn{u,v \epsilon V } are connected by an edge \mjseqn{e=(u,v)}.the edge weights \mjseqn{w(e)} are defined as the ratio of the number of GO terms co-occurring
 between two categories. Edge weights w(e) are defined as the ratio of the number of GO terms (e.g. biological processes) co-occurring between two categories
  \mjseqn{BP_{u} \ n  BP_{v}} compared to the total number of GO terms available.
 A node weight \mjseqn{K_{w}(u)} is defined as the sum of the edge weights where the node u is a participant. Thus, the node weight represents how frequently
  GO terms are reported and expressed in a biological phenomenon.

 \mjsdeqn{w(e) = \frac{\mid BP_{u} n {BP_{v}}\mid}{\mid BP\mid}} (1)

 \mjsdeqn{K_{w} = \sum_{{v} \epsilon {V}}{w(u,v)}} (2)


 GO option:

 The nodes \mjseqn{{V}} represent GO terms and the edges \mjseqn{{E}'} represent categories where a pair of GO terms co-occur. More specifically,
 two GO terms are connected by an edge \mjseqn{{e}'=({u},{v}')}. the edge weight \mjseqn{{w}'({e}')} corresponds to the number of categories co-occurring
  the GO terms \mjseqn{{u}} and \mjseqn{{v}'},compared with the total number of GO terms (Equation 3). A node weight \mjseqn{{K}'_w({u}')} is defined,in this case the weight
 represents the importance of a GO term (more frequent co-occurring).(Please be patient, it requires a long time to finish).

 \mjsdeqn{{w}'({e}')=\frac{\mid{Cu}'\cap  {Cv}'\mid}{\mid BP \mid}} (3)

 \mjsdeqn{{K}'_w({u}')=\sum_{{v}'\epsilon {V}'}{{w}'({u}',{v}')}} (4)
}
\examples{

#Loading example datasets
data(H_sapiens_compress)

GOterm_field <- "Functional_Category"

#Running function
x <- graphGOspecies(df=H_sapiens_compress,
                     GOterm_field=GOterm_field,
                     option = "Categories",
                     numCores=1,
                     saveGraph=FALSE,
                     outdir = NULL,
                     filename=NULL)

}
