% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{sampled.tree.from.combined}
\alias{sampled.tree.from.combined}
\title{Removes all unsampled lineages from a combined tree.
Extinct tips are only sampled if they are fossils. With default settings all extant tips are sampled.}
\usage{
sampled.tree.from.combined(tree, rho = 1, sampled_tips = NULL)
}
\arguments{
\item{tree}{Combined tree with fossils.}

\item{rho}{Sampling probability of extant tips. Default 1, will be disregarded if sampled_tips is not null.}

\item{sampled_tips}{List of tip labels corresponding to sampled extant tips.}
}
\value{
Sampled tree with fossils.
}
\description{
Removes all unsampled lineages from a combined tree.
Extinct tips are only sampled if they are fossils. With default settings all extant tips are sampled.
}
\examples{
# simulate tree
t = ape::rtree(6)

# simulate fossils
f = sim.fossils.poisson(rate = 2, tree = t)

# transform format
t2 = SAtree.from.fossils(t,f)

# transform to sampled tree
t3 = sampled.tree.from.combined(t2)
plot(t3)
}
