% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IncidenceForecast

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{IncidenceForecast}
\alias{IncidenceForecast}
\title{IncidenceForecast}
\description{A basic concrete SimulatedForecast class.}
\seealso{
Inherits from : \code{\link{SimulatedForecast}}

}
\examples{
data = SimulatedIncidenceMatrix$new(
  IncidenceMatrix$new(matrix(1:9,3,3)),
  nsim=3
)
data$addError(cols = 3,type='Poisson')
forecast = IncidenceForecast$new(data,forecastTimes=c(FALSE,FALSE,TRUE))
forecast
forecast$forecastTimes
forecast$forecastMadeTime
forecast$data$mat
forecast$nsim
forecast$sample$mat
forecast$sample$mat
forecast$mean()$mat
forecast$median()$mat
forecast$binDist(1:4*4)$arr
forecast$quantile(c(.05,.5,.95))$arr
}
\section{Fields}{
\describe{
\item{data}{The prediction this model is responsible for.  The data should be of class SimulatedIncidenceMatrix}
\item{forecastMadeTime}{When the forecast was created.}
\item{forecastTimes}{The times the forecast is about.}
\item{model}{The model used to create the forecast.}
\item{nsim}{The number of simulations.}
\item{sample}{Draw a random sample from the possible model predictions.  Please see implementation of the data for the properties of the sampling.}
}}
\section{Methods}{
\methodname{binDist(cutoffs)}{
Get the distribution of simulations of the data within fixed bins.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{cutoffs}{A numeric vector with elements to use as the dividing values for the bins.}
}}
\item{Value}{a FrameData.}
}}
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{initialize(data=SimulatedIncidenceMatrix$new(),forecastTimes=c())}{
Create a new IncidenceForecast.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{The data to initialize with}
}}}}
\methodname{mean()}{
This method extracts the elementwise mean of the forecast.  This function will not change the number of rows or columns in the data, but will convert probabilistic estimates into deterministic ones.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}}}
\methodname{median()}{
This method extracts the elementwise median of the forecast.  This function will not change the number of rows or columns in the data, but will convert probabilistic estimates into deterministic ones.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}
\item{Value}{a MatrixData.}
}}
\methodname{quantile(alphas)}{
Get the cutoffs for each percentile in alphas.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{alphas}{A numeric vector with elements between \code{0} and \code{1} of percentiles to find cutoffs for.}
}}
\item{Value}{an ArrayData.}
}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
