% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MoveAheadModel

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{MoveAheadModel}
\alias{MoveAheadModel}
\title{MoveAheadModel}
\description{An autoregressive model which assumes everything stays the same.}
\seealso{
Inherits from : \code{\link{RecursiveForecastModel}}

}
\examples{
MoveAheadModel <- R6Class(
  classname = 'MoveAheadModel',
  inherit = RecursiveForecastModel,
  private = list(
    .data = IncidenceMatrix$new(),
    newdata = IncidenceMatrix$new(),
    output = ArrayData$new(),
  	.nsim = 3,
    .predCols = c(as.integer(1)),
    .maxPredCol = as.integer(1)
  ),
  public = list(
    initialize = function(nsim = 3)\{
      private$.nsim = nsim
    \},
    fit_ = function()\{
      if(self$data$ncol <= self$predCols)\{
        stop("We cannot go further back than the start of the matrix.")
      \}
    \},
    predictRow_ = function(row,col=0)\{
      predict_(col)
    \},
    predict_ = function(col=0)\{
      if('predict_' \%in\% private$.debug)\{
        browser()
      \}
      if(col == 0)\{
        col=1:private$output$ncol
      \}
      private$output$mutate(
        cols=col,
        data = SimulatedIncidenceMatrix$new(
          private$newdata,
          private$.nsim
        )$simulations
      )
    \},
    prepareFitData = function(data)\{
      private$.data = data$clone(TRUE)
    \},
    preparePredictData = function(newdata)\{
      if('preparePredictData' \%in\% private$.debug)\{
        browser()
      \}
      private$newdata = SimulatedIncidenceMatrix$new(data=newdata,nsim=self$nsim)
      private$.nrow = private$newdata$nrow
      private$newdata$addColumns(min(self$predCols))
      private$newdata$lag(min(self$predCols),na.rm=FALSE)
      private$newdata$subset(cols=2:private$newdata$ncol)
    \},
    prepareForecastData = function(data)\{
      if(self$data$ncol <= self$predCols)\{
        stop("We cannot go further back than the start of the matrix.")
      \}
      private$newdata = data$clone(TRUE)
      private$.nrow = private$newdata$nrow
      private$newdata$addColumns(min(self$predCols))
      private$newdata$lag(min(self$predCols),na.rm=TRUE)
    \},
    prepareOutputData = function(inputData,steps=0)\{
      private$output = SimulatedIncidenceMatrix$new(inputData,private$.nsim)
      if(steps > 0)\{
        private$output$addColumns(steps)
      \}
    \}
  ),
  active = list(
    nsim = function(value)\{
      private$defaultActive(type='private',name='.nsim',val=value)
    \}
  )
)
}
\section{Fields}{
\describe{
\item{data}{A MatrixData containing the data used in fitting of the model.
}
\item{maxPredCol}{The farthest back column from the output value used in prediction.
}
\item{nsim}{The number of stochastic simulations to perform.}
\item{predCols}{An array of which columns are used in prediction.  1 means the column before the prediction, 2 the one before that etc.
}
\item{stochastic}{A string with the family of stochastic noise to apply to the recursive process.  Currently only accepts 'Deterministic' and 'Poisson' as values.
}
}}
\section{Methods}{
\methodname{fit(data)}{
Fit the model for predicting.  This method breaks down the fitting  process into two parts, data preparation, and the model fitting.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{The data to use to fit the model.  This object should be a  MatrixData object.
}
}}}}
\methodname{fit_()}{
This method is included for compliance with the standard but does nothing.  This model does not need to be fit.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}}}
\methodname{forecast(newdata = private$.data,steps=1)}{
Using a model previously fit with \code{fit} to predict the next \code{steps} columns.  This function assumes that all of the data preprocessing has already been taken care of.  This function is similar to predict, except that it can predict multiple time steps into the future instead of a single timestep.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{The data to forecast from.
}
\methoditem{steps}{The number of timesteps into the future to predict.
}
}}
\item{Value}{private$output This function should both modify and return private$output.
}
}}
\methodname{initialize(nsim = 3)}{
Create a new MoveAheadModel
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{nsim}{The number of stochastic simulations to use.}
}}}}
\methodname{predict(newdata)}{
Use a model previously fit with fit to predict. This function does not assume any data preprocessing.  This function should not, in general need  to be overwritten by the user.  The main prediction function is predict_, so please modify that function instead if possible.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{Optional.  The data used to predict.  This data should be a MatrixData object.
}
}}}}
\methodname{predictRow(newdata,row,col)}{
Using a model previously fit with \code{fitRow} to predict the  \code{row}th row of the next column. This function does not assume any data preprocessing.  Since the predict method predicts every row at the  the same time, we include this method for predicting only a single row.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{Optional.  The data use to predict.  This can either be a matrix, appropriately formatted lag vector, or NULL to predict based on the data used to fit.
}
\methoditem{row}{The row to predict the value of.
}
\methoditem{col}{This is for internal use only.
}
}}}}
\methodname{predictRow_(row,col=0)}{
This method predicts a particular row.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{row}{The row to predict}
\methoditem{col}{This is for internal use.}
}}}}
\methodname{predict_(col=0)}{
This method predicts as much as possible about the next time step.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{col}{This is for internal use.}
}}}}
\methodname{prepareFitData(data)}{
This method gets data ready for fitting and stores it in the model for later use.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{The data used to fit the model.}
}}}}
\methodname{prepareForecastData(data)}{
This method gets data ready to use to forecast and stores it in the model for later use.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{The data to use when forecasting.}
}}}}
\methodname{prepareOutputData(inputData,steps=0)}{
This method prepares the output for predict or forecast.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{inputData}{The data being used to predict/forecast.}
\methoditem{steps}{The number of steps in the forecast. (0 for predict).}
}}}}
\methodname{preparePredictData(newdata)}{
This method gets data ready to use to predict and stores it in the model for later use.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{The data to use when fitting the model.}
}}}}
}
