% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NASS_FUNCTIONS.R
\name{get_nass_cdl}
\alias{get_nass_cdl}
\alias{get_nass}
\alias{get_cdl}
\alias{cdl_colors}
\title{Download and crop the NASS Cropland Data Layer.}
\usage{
get_nass_cdl(
  template,
  label,
  year = 2019,
  extraction.dir = paste0(tempdir(), "/FedData/"),
  raster.options = c("COMPRESS=DEFLATE", "ZLEVEL=9", "INTERLEAVE=BAND"),
  force.redo = FALSE,
  progress = TRUE
)

get_nass(template, label, ...)

get_cdl(template, label, ...)

cdl_colors()
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve
as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{year}{An integer representing the year of desired NASS Cropland Data Layer product.
Acceptable values are 2007--the last year.}

\item{extraction.dir}{A character string indicating where the extracted and cropped NASS data should be put.
The directory will be created if missing.}

\item{raster.options}{a vector of options for terra::writeRaster.}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created?}

\item{progress}{Draw a progress bar when downloading?}

\item{...}{Other parameters passed on to [get_nass_cdl].}
}
\value{
A \code{RasterLayer} cropped to the bounding box of the template.
}
\description{
\code{get_nass_cdl} returns a \code{RasterLayer} of NASS Cropland Data Layer cropped to a given
template study area.
}
\examples{
\dontrun{
# Extract data for the Mesa Verde National Park:

# Get the NASS CDL (USA ONLY)
# Returns a raster
NASS <-
  get_nass_cdl(
    template = FedData::meve,
    label = "meve",
    year = 2011
  )

# Plot with raster::plot
plot(NASS)
}
}
