% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NLCD_FUNCTIONS.R
\name{get_nlcd_tile}
\alias{get_nlcd_tile}
\title{Download and crop a tile from the National Land Cover Database.}
\usage{
get_nlcd_tile(template = NULL, year = 2011, dataset = "landcover",
  tileName, raw.dir)
}
\arguments{
\item{template}{A \code{Raster*} or \code{Spatial*} object to serve 
as a template for cropping. If missing, entire tile is returned.}

\item{year}{An integer representing the year of desired NLCD product. Acceptable values are 2011 (default), 2006, and 2001.}

\item{dataset}{A character string representing type of the NLCD product. Acceptable values are landcover' (default), 'impervious', and 'canopy'.}

\item{tileName}{An character string representing tile to be downloaded. Will be of the form 'NxxWxxx', with the 'x' values as numbers.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created by \code{download_nlcd_tile} if missing. Defaults to './RAW/NLCD/'.}
}
\value{
A \code{RasterLayer} cropped within the specified \code{template}.
}
\description{
\code{get_nlcd_tile} returns a \code{RasterLayer} cropped within the specified \code{template}.
If template is not provided, returns the entire NLCD tile.
}
\keyword{internal}
