% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MulletBS.R
\docType{data}
\name{MulletBS}
\alias{MulletBS}
\title{Ages of Red Mullet assigned from whole and broken-burnt otoliths.}
\format{A data frame with 51 paired observations on the following 2 variables.
 \describe{
  \item{whole}{Ages assigned from whole otoliths.}
  \item{bb}{Ages assigned from broken/burnt otoliths.}
}}
\source{
Extracted from Figure 3 of Polat, N., D. Bostanci, S. Yilmaz.  2005.  Differences between whole otolith and broken-burnt otolith ages of red mullet (\emph{Mullus barbatus ponticus} Essipov, 1927) sampled from the Black Sea (Samsun, Turkey).  Turkish Journal of Veterinary and Animal Science 29:429-433.
}
\description{
Ages assigned to whole and broken-burnt otoliths of Red Mullet (\emph{Mullus barbatus ponticus}) sampled from the Black Sea (Samsun, Turkey).
}
\section{Topic(s)}{

 \itemize{
   \item Age comparison
   \item Age precision
   \item Age Bias
   \item Ageing error
 }
}
\examples{
data(MulletBS)
str(MulletBS)
head(MulletBS)
plot(whole~bb,data=MulletBS)
xtabs(~bb+whole,data=MulletBS)
}
\concept{
Age Precision Bias 'Age Comparison'
}
\keyword{datasets}

