% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmjmcmc.R
\name{gmjmcmc}
\alias{gmjmcmc}
\title{Main algorithm for GMJMCMC (Genetically Modified MJMCMC)}
\usage{
gmjmcmc(
  data,
  loglik.pi = gaussian.loglik,
  loglik.alpha = gaussian.loglik.alpha,
  transforms,
  P = 10,
  N.init = 100,
  N.final = 100,
  probs = NULL,
  params = NULL,
  sub = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{A matrix containing the data to use in the algorithm,
first column should be the dependent variable,
and the rest of the columns should be the independent variables.}

\item{loglik.pi}{The (log) density to explore}

\item{loglik.alpha}{The likelihood function to use for alpha calculation}

\item{transforms}{A Character vector including the names of the non-linear functions to be used by the modification
and the projection operator.}

\item{P}{The number of generations for GMJMCMC (Genetically Modified MJMCMC).
The default value is $P = 10$.
A larger value like $P = 50$ might be more realistic for more complicated examples where one expects a lot of non-linear structures.}

\item{N.init}{The number of iterations per population (total iterations = (T-1)*N.init+N.final)}

\item{N.final}{The number of iterations for the final population (total iterations = (T-1)*N.init+N.final)}

\item{probs}{A list of the various probability vectors to use}

\item{params}{A list of the various parameters for all the parts of the algorithm}

\item{sub}{An indicator that if the likelihood is inexact and should be improved each model visit (EXPERIMENTAL!)}

\item{verbose}{A logical denoting if messages should be printed}
}
\value{
A list containing the following elements:
\item{models}{All models per population.}
\item{lo.models}{All local optimization models per population.}
\item{populations}{All features per population.}
\item{marg.probs}{Marginal feature probabilities per population.}
\item{model.probs}{Marginal feature probabilities per population.}
\item{model.probs.idx}{Marginal feature probabilities per population.}
\item{best.margs}{Best marginal model probability per population.}
\item{accept}{Acceptance rate per population.}
\item{accept.tot}{Overall acceptance rate.}
\item{best}{Best marginal model probability throughout the run, represented as the maximum value in \code{unlist(best.margs)}.}
}
\description{
Main algorithm for GMJMCMC (Genetically Modified MJMCMC)
}
\examples{
result <- gmjmcmc(matrix(rnorm(600), 100), P = 2, gaussian.loglik, NULL, c("p0", "exp_dbl"))
summary(result)
plot(result)

}
