% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{view}
\alias{view}
\alias{view,binClstPath-method}
\alias{view,data.frame-method}
\title{Path fast view}
\usage{
view(obj, ...)

\S4method{view}{binClstPath}(obj, lbl = NULL, lims = NULL, bg = NULL,
  ...)

\S4method{view}{data.frame}(obj, lbl = NULL, lims = NULL, bg = NULL,
  ...)
}
\arguments{
\item{obj}{A \link{binClstPath_instance} or a data.frame with the format
described for slot \code{binClstPath@pth}.}

\item{...}{Parameters \code{lbl} and \code{lims} are optional.}

\item{lbl}{A numeric vector with location labels. If \code{obj} is a
\link{binClstPath_instance} the clustering labels are used by default.}

\item{lims}{A numeric vector with lower and upper limit locations to show
only a chunk of the trajectory.}

\item{bg}{A valid colour to be used as background colour. By default a light-grey colour is used to enhance data points visibility.}
}
\description{
\code{view} provides a fast plot of a segmented trajectory or
  specific chunks of it.
}
\examples{
# -- Fast view of the binClstPath instance included in the package --
view(expth)
# -- the same with reference labels --
view(expth,lbl=TRUE)
}
